#include <atmel_start.h>

#include "FreeRTOS.h"
#include "task.h"

#include "debug_print.h"
#include "demo_app.h"
#include "lte_ifc_task.h"

int main(void)
{
	// Initializes MCU, drivers and middleware
	atmel_start_init();

    // Initialize printf() facility through Virtual COM port
	debug_print_init();
	
    // Initialize LTE Interface task
	lte_ifc_task_init();

    // Initialize demo application task
    demo_app_task_init();
	
    // Kick off scheduler
    vTaskStartScheduler();
}
