

#include <stdint.h>
#include <atmel_start.h>

#include "FreeRTOS.h"

#include "lte_ifc_hal.h"

static struct lte_ifc_time s_current_uptime = 
{
    .tv_sec = 0, 
    .tv_nsec = 0
};

int32_t lte_ifc_hal_gettime(struct lte_ifc_time *tp)
{
    // Critical region to prevent s_current_uptime from being
    // modified while copied out
    taskENTER_CRITICAL();
    tp->tv_sec = s_current_uptime.tv_sec;
    tp->tv_nsec = s_current_uptime.tv_nsec;
    taskEXIT_CRITICAL();    
    
    return 0;
}

#if configUSE_TICKLESS_IDLE != 0
#error "This function needs to be re-written for TICKLESS_IDLE"
#endif
void vApplicationTickHook(void)
{
    static const uint32_t nsec_increment_per_tick = ((uint32_t)1e9)/configTICK_RATE_HZ;
    s_current_uptime.tv_nsec += nsec_increment_per_tick;
    
    if (s_current_uptime.tv_nsec >= ((uint32_t)1e9))
    {
        s_current_uptime.tv_nsec -= (uint32_t)1e9;
        s_current_uptime.tv_sec++;
        gpio_toggle_pin_level(LED0);
    }
}

