#ifndef __LTE_IFC_TASK_H__
#define __LTE_IFC_TASK_H__

typedef enum
{
    LTE_TASK_SUCCESS,
    LTE_TASK_QUEUE_FAIL,
    LTE_TASK_MOD_NOT_READY,
    LTE_TASK_SEND_MSG_INVALID_LEN,
    LTE_TASK_SEND_MSG_INVALID_BUF,
} lte_task_ret_t;

lte_task_ret_t lte_send_msg(const uint8_t* payload, uint16_t len);

lte_task_ret_t lte_downlink_check(void);

typedef struct
{
    // Returns 0 if Tx Success, Negative otherwise
    void (*lte_cb_on_tx_done)(int32_t);

    // Returns 0 if Tx Success, Negative otherwise
    void (*lte_cb_on_mailbox_check_done)(int32_t);
        
    // Returns a Length of 0 if mailbox is empty
    void (*lte_cb_on_rx_done)(uint8_t* msg, uint16_t len);
        
//    uint32_t connect_interval_s;
//    uint32_t mailbox_check_int_s;
//    void (*sym_set_boot)(sym_boot_t state, void * context);
//    void (*sym_init_uart)(struct usart_sync_descriptor* rlp_uart, void * context);
//    void (*sym_on_sleep)(void * context);
//    void (*sym_on_wake)(void * context);
//    void (*sym_on_state_change)(sym_module_state_t previous_state, sym_module_state_t new_state, void * context);
//    void * context;
} lte_task_config_t;
void lte_task_update_config(lte_task_config_t* cfg);
void lte_ifc_task_init(void);

#endif //__LTE_IFC_TASK_H__