
#include <atmel_start.h>
#include <stdint.h>

#include "lte_ifc_hal.h"

// #define DEBUG_PRINT_EVERY_BYTE

extern struct usart_async_descriptor USART_0;
static struct io_descriptor* s_lte_uart_io_desc;

int32_t lte_ifc_hal_tty_open(const char * dev_name, int baudrate)
{
    (void)dev_name;
    (void)baudrate;
    
	usart_async_get_io_descriptor(&USART_0, &s_lte_uart_io_desc);
    
    _usart_async_set_irq_state(&USART_0.device, USART_ASYNC_RX_DONE, true); 
    
	usart_async_enable(&USART_0);
    
    return 0;
}


int32_t lte_ifc_hal_write(uint8_t *buff, uint16_t len)
{
    (void)buff;
    (void)len;
    
#ifdef DEBUG_PRINT_EVERY_BYTE        
    debug_printf("Tx: ");
    for (int n=0; n<len; n++)
    {
        debug_printf("0x%02X ", buff[n]);
    }
    debug_printf("\n");
#endif    
	io_write(s_lte_uart_io_desc, (const uint8_t *)buff, len);
    
    // The io_write is an asynchronous call (the bytes are not copied out, 
    // and the interrupt will keep pulling bytes from there. This makes a 
    // nasty bug. Avoid by sitting here until all bytes sent.
    volatile uint16_t* p_tx_por = (volatile uint16_t*)&USART_0.tx_por;
    volatile uint16_t* p_tx_len = (volatile uint16_t*)&USART_0.tx_buffer_length;
    
    while((*p_tx_por) != (*p_tx_len)) { }
        
    return 0;
}
int32_t lte_ifc_hal_read_byte(uint8_t *buff)
{
    uint16_t bytes_read = 0;
    bytes_read = io_read(s_lte_uart_io_desc, (uint8_t *const)buff, 1);
    
    if (bytes_read == 1)
    {
#ifdef DEBUG_PRINT_EVERY_BYTE        
        debug_printf("Rx:\t0x%02X\n", *buff);
#endif        
        return 0;
    }
    else
    {
        return -1;
    }
}

int32_t lte_ifc_hal_set_wake_request(bool wake)
{
    if (wake)
    {
        PIN_OUT_LO(MODULE_WAKE_REQUEST_OUT);
    }
    else
    {
        PIN_OUT_HI(MODULE_WAKE_REQUEST_OUT);
    }        
    return 0;
}

int32_t lte_ifc_hal_get_wake_status(bool* p_wake)
{
    bool level = PIN_GET_LEVEL(MODULE_WAKE_STATUS_IN);
    *p_wake = level;
    return 0;
}
    
int32_t lte_ifc_hal_get_irq_flags_gpio(bool* p_level)
{
    bool level = PIN_GET_LEVEL(MODULE_HOST_NOTIFY_IN);
    *p_level = level;
    return 0;
}
