#ifndef __LTE_IFC_ERROR_H__
#define __LTE_IFC_ERROR_H__

/** Error Codes */
typedef enum lte_ifc_error_codes_e {
    LTE_IFC_ERROR_INCORRECT_PARAMETER        = -201, ///< The parameter value was invalid.
    LTE_IFC_ERROR_INCORRECT_RESPONSE_LENGTH  = -202, ///< Module response was not the expected size.
    LTE_IFC_ERROR_MESSAGE_NUMBER_MISMATCH    = -203, ///< Message number in response doesn't match expected
    LTE_IFC_ERROR_CHECKSUM_MISMATCH          = -204, ///< Checksum mismatch
    LTE_IFC_ERROR_COMMAND_MISMATCH           = -205, ///< Command mismatch (responding to a different command)
    LTE_IFC_ERROR_HOST_INTERFACE_TIMEOUT     = -206, ///< Timed out waiting for Rx bytes from interface
    LTE_IFC_ERROR_BUFFER_TOO_SMALL           = -207, ///< Response larger than provided output buffer
    LTE_IFC_ERROR_START_OF_FRAME             = -208, ///< transport_read failed getting FRAME_START
    LTE_IFC_ERROR_HEADER                     = -209, ///< transport_read failed getting header
    LTE_IFC_ERROR_TIMEOUT                    = -210, ///< The operation timed out.
    LTE_IFC_ERROR_INCORRECT_MESSAGE_SIZE     = -211, ///< The message size from the device was incorrect.
    LTE_IFC_ERROR_NO_NETWORK                 = -212, ///< No network was available.
    LTE_IFC_ERROR_WAKEUP_TIMEOUT             = -213, ///< Wakeup Timeout.
    LTE_IFC_ERROR_WAKEUP_SET                 = -214, ///< Setting wakeup request
    LTE_IFC_ERROR_WAKEUP_GET                 = -215, ///< Getting wakeup status
    LTE_IFC_ERROR_IRQFLAGS_GPIO_GET          = -216, ///< Getting IRQ Flags GPIO line state
    /* When adding a new value, update lte_ifc_ack_desc() */
} lte_ifc_error_codes_t;

#endif //__LTE_IFC_ERROR_H__
