/*
 * Code generated from Atmel Start.
 *
 * This file will be overwritten when reconfiguring your Atmel Start project.
 * Please copy examples or other code you want to keep to a separate file
 * to avoid losing it when reconfiguring.
 */

#include "driver_init.h"
#include <peripheral_clk_config.h>
#include <utils.h>
#include <hal_init.h>

struct usart_async_descriptor USART_0;
struct usart_sync_descriptor USART_3;

#define LTE_UART_RX_BUF_SIZE (1024)
static uint8_t s_lte_uart_rx_buf[LTE_UART_RX_BUF_SIZE];

void USART_0_init(void)
{
	// Clock Init
	hri_gclk_write_PCHCTRL_reg(GCLK, SERCOM0_GCLK_ID_CORE, CONF_GCLK_SERCOM0_CORE_SRC | (1 << GCLK_PCHCTRL_CHEN_Pos));
	hri_gclk_write_PCHCTRL_reg(GCLK, SERCOM0_GCLK_ID_SLOW, CONF_GCLK_SERCOM0_SLOW_SRC | (1 << GCLK_PCHCTRL_CHEN_Pos));
	hri_mclk_set_APBCMASK_SERCOM0_bit(MCLK);
	// Driver init
	usart_async_init(&USART_0, SERCOM0, s_lte_uart_rx_buf, LTE_UART_RX_BUF_SIZE, NULL);
	// Port init
	gpio_set_pin_function(PA04, PINMUX_PA04D_SERCOM0_PAD0);
	gpio_set_pin_function(PA05, PINMUX_PA05D_SERCOM0_PAD1);
	gpio_set_pin_function(PA06, PINMUX_PA06D_SERCOM0_PAD2);
	gpio_set_pin_function(PA07, PINMUX_PA07D_SERCOM0_PAD3);
}

void USART_3_init(void)
{
	// Clock Init
	hri_gclk_write_PCHCTRL_reg(GCLK, SERCOM3_GCLK_ID_CORE, CONF_GCLK_SERCOM3_CORE_SRC | (1 << GCLK_PCHCTRL_CHEN_Pos));
	hri_gclk_write_PCHCTRL_reg(GCLK, SERCOM3_GCLK_ID_SLOW, CONF_GCLK_SERCOM3_SLOW_SRC | (1 << GCLK_PCHCTRL_CHEN_Pos));
	hri_mclk_set_APBCMASK_SERCOM3_bit(MCLK);
	// Driver init
	usart_sync_init(&USART_3, SERCOM3, (void *)NULL);
	// Port init
	gpio_set_pin_function(PA22, PINMUX_PA22C_SERCOM3_PAD0);
	gpio_set_pin_function(PA23, PINMUX_PA23C_SERCOM3_PAD1);
}

void system_init(void)
{
	init_mcu();

	// Set LED0 pin direction to output
	gpio_set_pin_direction(LED0, GPIO_DIRECTION_OUT);
	gpio_set_pin_level(LED0, false);
	gpio_set_pin_function(LED0, GPIO_PIN_FUNCTION_OFF);

	USART_0_init();
	USART_3_init();

    // TEMP - Move this to lte (tty?) init/de-init functions
    PIN_IN_OFF(MODULE_HOST_NOTIFY_IN);
    PIN_OUT_HI(MODULE_WAKE_REQUEST_OUT);
    PIN_IN_OFF(MODULE_WAKE_STATUS_IN);
}
