#include <stdarg.h>
#include <stdbool.h>
#include <stdio.h>

#include "FreeRTOS.h"
#include "semphr.h"

#include "driver_init.h"
#include "debug_print.h"

extern struct usart_sync_descriptor USART_3;
static struct io_descriptor* s_dbg_uart_io_desc;

// Mutex used by tasks to lock printf not sure if its thread-safe
static SemaphoreHandle_t s_debug_print_mutex = NULL;

static bool s_initialized = false;

void debug_print_init(void)
{
	usart_sync_get_io_descriptor(&USART_3, &s_dbg_uart_io_desc);
	usart_sync_enable(&USART_3);
	
	s_debug_print_mutex = xSemaphoreCreateMutex();
	ASSERT(s_debug_print_mutex != NULL);
	
	s_initialized = true;
}

void debug_printf(const char *format, ...)
{
    va_list args;
    va_start(args, format);

	if (s_initialized)
	{
        if (pdTRUE == xSemaphoreTake(s_debug_print_mutex, portMAX_DELAY))
        {
            vprintf(format, args);
            xSemaphoreGive(s_debug_print_mutex);
        }
	}
    va_end(args);
}

int _write (int fd, char *ptr, int len)
{
  /* Write "len" of char from "ptr" to file id "fd"
   * Return number of char written.
   * Need implementing with UART here. */
	(void)fd;
	io_write(s_dbg_uart_io_desc, (const uint8_t *)ptr, len);
    return len;
}

int _read (int fd, char *ptr, int len)
{
  /* Read "len" of char to "ptr" from file id "fd"
   * Return number of char read.
   * Need implementing with UART here. */
  
	(void)fd;
	(void)ptr;
	(void)len;
  
    return len;
}