/*
 * Code generated from Atmel Start.
 *
 * This file will be overwritten when reconfiguring your Atmel Start project.
 * Please copy examples or other code you want to keep to a separate file
 * to avoid losing it when reconfiguring.
 */
#ifndef ATMEL_START_PINS_H_INCLUDED
#define ATMEL_START_PINS_H_INCLUDED

#include <hal_gpio.h>

// SAML21 has 9 pin functions

#define GPIO_PIN_FUNCTION_A 0
#define GPIO_PIN_FUNCTION_B 1
#define GPIO_PIN_FUNCTION_C 2
#define GPIO_PIN_FUNCTION_D 3
#define GPIO_PIN_FUNCTION_E 4
#define GPIO_PIN_FUNCTION_F 5
#define GPIO_PIN_FUNCTION_G 6
#define GPIO_PIN_FUNCTION_H 7
#define GPIO_PIN_FUNCTION_I 8

#define PA04 GPIO(GPIO_PORTA, 4)
#define PA05 GPIO(GPIO_PORTA, 5)
#define PA06 GPIO(GPIO_PORTA, 6)
#define PA07 GPIO(GPIO_PORTA, 7)

#define PA22 GPIO(GPIO_PORTA, 22)
#define PA23 GPIO(GPIO_PORTA, 23)

#define LED0 GPIO(GPIO_PORTB, 10)

#define MODULE_HOST_NOTIFY_IN   GPIO(GPIO_PORTB, 4)
// This is the long term solution
#define MODULE_WAKE_REQUEST_OUT GPIO(GPIO_PORTA, 2)
#define MODULE_WAKE_STATUS_IN   GPIO(GPIO_PORTA, 8)

// This is the stopgap until we get 4-pin flow control on the module
//#define MODULE_WAKE_REQUEST_OUT GPIO(GPIO_PORTA, 6)
//#define MODULE_WAKE_STATUS_IN   GPIO(GPIO_PORTA, 7)

// Helper macros
// Reset State (Configured as input, with input buffers, output buffers and pull disabled)
#define PIN_OFF(x)     {gpio_set_pin_direction(x,   GPIO_DIRECTION_OFF);\
                        gpio_set_pin_pull_mode(x, GPIO_PULL_OFF);       \
                        gpio_set_pin_function(x, GPIO_PIN_FUNCTION_OFF);}

#define PIN_IN_UP(x)   {gpio_set_pin_pull_mode(x, GPIO_PULL_UP);        \
                        gpio_set_pin_function(x, GPIO_PIN_FUNCTION_OFF);}

#define PIN_IN_DOWN(x) {gpio_set_pin_direction(x, GPIO_DIRECTION_IN);   \
                        gpio_set_pin_pull_mode(x, GPIO_PULL_DOWN);      \
                        gpio_set_pin_function(x, GPIO_PIN_FUNCTION_OFF);}

#define PIN_IN_OFF(x)  {gpio_set_pin_direction(x, GPIO_DIRECTION_IN);   \
                        gpio_set_pin_pull_mode(x, GPIO_PULL_OFF);       \
                        gpio_set_pin_function(x, GPIO_PIN_FUNCTION_OFF);}

#define PIN_OUT_LO(x) {gpio_set_pin_level(x, false); \
                       gpio_set_pin_direction(x, GPIO_DIRECTION_OUT);   \
                       gpio_set_pin_function(x, GPIO_PIN_FUNCTION_OFF);}

#define PIN_OUT_HI(x) {gpio_set_pin_level(x, true); \
                       gpio_set_pin_direction(x, GPIO_DIRECTION_OUT);   \
                       gpio_set_pin_function(x, GPIO_PIN_FUNCTION_OFF);}

#define PIN_IN_FUNC(x,y)     {gpio_set_pin_direction(x, GPIO_DIRECTION_IN);   \
                              gpio_set_pin_pull_mode(x, GPIO_PULL_OFF); \
                              gpio_set_pin_function(x, y);}

#define PIN_IN_UP_FUNC(x,y)  {gpio_set_pin_direction(x, GPIO_DIRECTION_IN);   \
                              gpio_set_pin_pull_mode(x, GPIO_PULL_UP); \
                              gpio_set_pin_function(x, y);}

#define PIN_IN_DN_FUNC(x,y)  {gpio_set_pin_direction(x, GPIO_DIRECTION_IN);   \
                              gpio_set_pin_pull_mode(x, GPIO_PULL_DOWN); \
                              gpio_set_pin_function(x, y);}

#define PIN_OUT_LO_FUNC(x,y) {gpio_set_pin_direction(x, GPIO_DIRECTION_OUT); \
                              gpio_set_pin_level(x, false); \
                              gpio_set_pin_function(x, y);}

#define PIN_OUT_HI_FUNC(x,y) {gpio_set_pin_direction(x, GPIO_DIRECTION_OUT); \
                              gpio_set_pin_level(x, false); \
                              gpio_set_pin_function(x, y);}

#define PIN_GET_LEVEL(x)     (gpio_get_pin_level(x))

#endif // ATMEL_START_PINS_H_INCLUDED
